/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.network.FirewallAdmin;
import com.ibm.hwmca.base.settings.network.FirewallAdminException;
import com.ibm.hwmca.base.settings.network.FirewallRule;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.shutdown.ShutdownListener;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.shutdown.ShutdownRequest;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;

public class BaseFirewallManager
implements Runnable,
ShutdownListener {
    private static FirewallAdmin fwAdmin = FirewallAdmin.getFirewallAdmin();
    private static PersistenceManager persistenceManager = PersistenceManager.getPersistenceManager();
    private static final String TRACE_MASKT = "XBFWMGRT";
    private static final String TRACE_MASKF = "XBFWMGRF";
    private static final String TRACE_MASKD = "XBFWMGRD";
    private static final String PERSIST_KEY = "com.ibm.hwmca.base.settings.network.PersistedFirewallRules";
    private static PersistedFirewallRules persistedRules;

    public void run() {
        Trace.trace(TRACE_MASKT, "-> BaseFirwallManager.run");
        Trace.trace(TRACE_MASKD, "BaseFirewallManager: adding ourselves as a ShutdownListener");
        ShutdownManager.getShutdownManager().addShutdownListener(this);
        if (!persistedRules.isEmpty()) {
            Trace.trace(TRACE_MASKF, "BaseFirewallManager: adding persisted rules");
            Iterator it = persistedRules.iterator();
            while (it.hasNext()) {
                FirewallRule rule = (FirewallRule)it.next();
                try {
                    fwAdmin.addFirewallRule(rule);
                }
                catch (FirewallAdminException e) {
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "BaseFirewallManager: no persisted rules to add");
        }
        Trace.trace(TRACE_MASKT, "<- BaseFirewallManager.run");
    }

    public void shutdownStarting(ShutdownRequest request, long delay) {
        Trace.trace(TRACE_MASKF, "BaseFirewallManager.shutdownStarting: flushing firewall chains");
        try {
            fwAdmin.flushFirewallChains();
        }
        catch (FirewallAdminException e) {
            Trace.trace(TRACE_MASKF, e);
        }
    }

    public static void addPersistedFirewallRule(FirewallRule rule) throws FirewallAdminException, PersistenceException {
        Trace.trace(TRACE_MASKF, "-> BaseFirewallManager.addPersistedFirewallRule");
        fwAdmin.addFirewallRule(rule);
        persistedRules.add(rule);
        persistenceManager.write(PERSIST_KEY, persistedRules);
        Trace.trace(TRACE_MASKF, "<- BaseFirewallManager.addPersistedFirewallRule");
    }

    public static void removePersistedFirewallRule(FirewallRule rule) throws FirewallAdminException, PersistenceException {
        Trace.trace(TRACE_MASKF, "-> BaseFirewallManager.removePersistedFirewallRule");
        fwAdmin.removeFirewallRule(rule);
        persistedRules.remove(rule);
        persistenceManager.write(PERSIST_KEY, persistedRules);
        Trace.trace(TRACE_MASKF, "<- BaseFirewallManager.removePersistedFirewallRule");
    }

    public static void addPersistedFirewallRules(String sourceAddr, String sourceAddrMask, String protocol, String port) throws FirewallAdminException, PersistenceException {
        Trace.trace(TRACE_MASKF, "-> BaseFirewallManager.addPersistedFirewallRules");
        Iterator it = NetworkSettings.getNetworkSettings().getNetworkInterfaceInfo().iterator();
        while (it.hasNext()) {
            NetworkInterfaceInformation netInfo = (NetworkInterfaceInformation)it.next();
            FirewallRule rule = new FirewallRule(netInfo.getIfname(), sourceAddr, sourceAddrMask, protocol, port);
            Trace.trace(TRACE_MASKF, "BaseFirewallManager: adding rule [" + rule + "]");
            fwAdmin.addFirewallRule(rule);
            persistedRules.add(rule);
        }
        persistenceManager.write(PERSIST_KEY, persistedRules);
        Trace.trace(TRACE_MASKF, "<- BaseFirewallManager.addPersistedFirewallRules");
    }

    public static void removePersistedFirewallRules(String sourceAddr, String sourceAddrMask, String protocol, String port) throws FirewallAdminException, PersistenceException {
        Trace.trace(TRACE_MASKF, "-> BaseFirewallManager.removePersistedFirewallRules");
        Iterator it = NetworkSettings.getNetworkSettings().getNetworkInterfaceInfo().iterator();
        while (it.hasNext()) {
            NetworkInterfaceInformation netInfo = (NetworkInterfaceInformation)it.next();
            FirewallRule rule = new FirewallRule(netInfo.getIfname(), sourceAddr, sourceAddrMask, protocol, port);
            fwAdmin.removeFirewallRule(rule);
            if (!persistedRules.remove(rule)) continue;
            Trace.trace(TRACE_MASKF, "BaseFirewallManager: removed rule [" + rule + "]");
        }
        persistenceManager.write(PERSIST_KEY, persistedRules);
        Trace.trace(TRACE_MASKF, "<- BaseFirewallManager.removePersistedFirewallRules");
    }

    static {
        try {
            persistedRules = persistenceManager.contains(PERSIST_KEY) ? (PersistedFirewallRules)persistenceManager.read(PERSIST_KEY) : new PersistedFirewallRules();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class PersistedFirewallRules
    extends ArrayList
    implements PersistentData {
        static final long serialVersionUID = 6174947268308683225L;

        private PersistedFirewallRules() {
        }
    }
}

